********************************************************************************************************************;
*** Informed consent (V1.0) part1                                                                                ***;
***Programmer: Haikun Bao                                                                                        ***;
***Created on: 01/22/2018                                                                                        ***;
********************************************************************************************************************;

********************************************************************************************************************;
***Specify various file pathes                                                                                   ***;                                                                     *********;
********************************************************************************************************************;
%let path1=Y:\MedPAR\2016; /*raw data files path, must be changed*/
%let path2=Y:\Denominator\2016; /*raw data files path, must be changed*/

%let path3=H:\DOC\Informed consent\SAS pack ICD10\Formats; /*format file path to save formats, must be changed*/
%let path4=H:\DOC\Informed consent\SAS pack ICD10\data; /*permanent output files path, must be changed*/
%let path5=H:\DOC\Informed consent\SAS pack ICD10; /*All the SAS program files path, must be changed*/

LIBNAME mpar16 "&path1";
LIBNAME den16  "&path2";
LIBNAME FORMAT "&path3";

LIBNAME PF "&path4";

options fmtsearch=(FORMAT.CCS_ten_formats FORMAT.Label_formats);

/*include all the MACROs*/
%include "&path5\IC_Macros.sas";
**********************************************************************************;
*select procedures in inpatient planned admission claims for different years;
%inpat(yr=16, out=ip16);

data ip_prc(drop=prcdt);/*select palnned procedure with age>=18*/
   set ip16;
   where dob^=. and age>=18;
   length CC_proc $ 10;
   CC_proc=put(prcdr,$CCS10PROC.);
   proc_dt=datejul(prcdt);
   format admsn_dt dsch_dt proc_dt mmddyy10.;
   drop medpar_admsn_dt medpar_dschrg_dt;
run;

***select restricted CCs;
data ip_prc_restricted1; /*select procedures in specific CCS categories*/
   set ip_prc;
   proc_exclude=put(prcdr,$Proc10exc.); 
   ccs=CC_proc*1;
   if ccs in (
      1	2 3	4 5	6 7	8 9																									
      14 15	16 17 18 19	20 21																										
      10 22	24 26 29 30	32 33 35																									
      36 40	41 42 43 44	45 48 49 52	62 63																						
      51 53	55 56 59 60	61																											
      11 12	64 66 67 69	71 72 73 74	75 78 79 84	85 86 87 88	89 90 92 93	94 95 96 97	98 99 159 165 166 167 163 164
      100 101 103 104 106 107 109 110 111 112 113 114 116 117 118																			
      119 120 121 123 124 125 127 129 130 131 132 134																						
      142 144 145 146 147 148 149 150 152 153 154 156 157 158 160 161 162																	
      168 170 171 172 173 174 175																											
      ) and proc_exclude^="PROC Exclude";
run;

data ip_prc_restricted2;/*exclude some CCS and procedures*/
   set ip_prc_restricted1;
   if substr(reverse(trim(hicno)),1,1)^="A" then exc1=1; else exc1=0;
   if ccs in (1	2 3	4 5	6 7	8 9) then cat=1;
   else if ccs in (14 15 16 17 18 19 20 21) then cat=2;
   else if ccs in (10 22 24 26 29 30 32 33 35) then cat=3;
   else if ccs in (36 40 41 42 43 44 45 48 49 52 62 63) then cat=4;
   else if ccs in (51 53 55 56 59 60 61) then cat=5;
   else if ccs in (11 12 64 66 67 69 71 72 73 74 75 78 79 84 85 86 87 88 89 90 92 93 94 95 96 97 98 99 159 165 166 167 163 164) then cat=6;
   else if ccs in (100 101 103 104 106 107 109 110 111 112 113 114 116 117 118) then cat=7;
   else if ccs in (119 120 121 123 124 125 127 129 130 131 132 134) then cat=8;
   else if ccs in (142 144 145 146 147 148 149 150 152 153 154 156 157 158 160 161 162) then cat=9;
   else if ccs in (168 170 171 172 173 174 175) then cat=10;
   length cc_label proc_label $550;
   cc_label=put(cc_proc,$Ccsprlab.);  
   proc_label=put(prcdr,$PROC10LAB.);  
   rand=ranuni(23456);
run;

proc sort; by medpar_clm_id proc_dt rand; run;

data ip_prc_restricted3;
   set ip_prc_restricted2;
   by medpar_clm_id proc_dt rand;
   if first.medpar_clm_id^=1 then exc2=1; else exc2=0;
run;

data ip_prc_restricted;/*exclude hic number who are not the primary FFS beneficiary and select one procedure in one claim*/
   set ip_prc_restricted3;
   if exc1^=1 and exc2^=1;
run;

proc sql;
   create table inpt_vol as select distinct prvid, count(*) as vol, count(distinct cat) as group_vol from ip_prc_restricted group by prvid;
quit;

**********select procedures from hosp;
data hosplist;
   set inpt_vol;
   if vol>=150 then ip_hosp=1;
   if 100<=vol<150 then ip_hosp=2;
   if vol<100 then ip_hosp=3;  
run;

proc freq data=hosplist; table ip_hosp/missing; run;

proc sql noprint;/*find hospitals with more than 150 elective procedures*/ 
  select distinct prvid into :hosplist separated by " " from hosplist where ip_hosp=1;
quit;

%INPT_SELECT_full(in=ip_prc_restricted, HOSPs=&hosplist, out=ip_selected150);

data pf.Selected_sample;
  set ip_selected150;
  label hicno="HIC number"
        dob="Date of birth"
		sex="Gender"
		admsn_dt="Admission date"
		dsch_dt="Discharge date"
		prcdr="ICD-10 procedure code"
        proc_dt="Procedure date"
		proc_label="Procedure description"
		prvid="Provider ID"
		cat="Procedure category"
		;
  format dob mmddyy10.;
  keep cat hicno dob sex race admsn_dt dsch_dt prcdr proc_dt proc_label prvid;  
run;

proc datasets nodetails;
  delete ip16 ip_prc ip_prc_restricted1 ip_prc_restricted2 ip_prc_restricted3
         ip_prc_restricted inpt_vol hosplist ip_selected150;
run;
